/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.framerelay;

import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.I18NString;
import ibm.nways.jdm.JdmServerImpl;
import ibm.nways.jdm.StatusType;
import ibm.nways.jdm.modelgen.StatusMapper;
import ibm.nways.jdm.modelgen.StatusModelInfo;
import ibm.nways.jdm.modelgen.TableStatusNamer;
import java.util.Locale;

public class ActionFrameRelay
implements StatusMapper,
TableStatusNamer {
    private static String bundleName = "ibm.nways.framerelay.Resources";
    private boolean loggingOn = false;

    public ActionFrameRelay() {
        String string = JdmServerImpl.getProperty("startLogging");
        if (string != null && string.equals("yes")) {
            this.loggingOn = true;
        }
    }

    public void calculateStatus(StatusModelInfo statusModelInfo, StatusModelInfo statusModelInfo2) {
        try {
            Object[] objectArray = statusModelInfo.getIndexes();
            if (this.loggingOn) {
                System.out.println("ActionFrameRelay");
                System.out.println("Interface " + objectArray[0].toString() + " DLCI " + objectArray[1].toString());
                System.out.println("State           = " + statusModelInfo.get("Panel.FrCircuitState"));
            }
            int n = (Integer)statusModelInfo.get("Panel.FrCircuitState");
            StatusAndExplain statusAndExplain = this.evaluateStatus(n, objectArray);
            statusModelInfo.setStatusType(statusAndExplain.statType, statusAndExplain.explain, true);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public I18NString nameThatObject(StatusModelInfo statusModelInfo) {
        Object[] objectArray = statusModelInfo.getIndexes();
        I18NMsgFormat i18NMsgFormat = new I18NMsgFormat(bundleName, "STATUS_NAME", objectArray);
        return i18NMsgFormat;
    }

    public I18NString nameThatTableObject(StatusModelInfo statusModelInfo) {
        I18NString i18NString = new I18NString(bundleName, "STATUS_TABLE_NAME");
        return i18NString;
    }

    private StatusAndExplain evaluateStatus(int n, Object[] objectArray) {
        StatusAndExplain statusAndExplain = new StatusAndExplain();
        switch (n) {
            case 1: {
                statusAndExplain.statType = StatusType.MARGINAL;
                statusAndExplain.explain = new I18NMsgFormat(bundleName, "INVALID", objectArray);
                break;
            }
            case 2: {
                statusAndExplain.statType = StatusType.NORMAL;
                statusAndExplain.explain = new I18NMsgFormat(bundleName, "ACTIVE", objectArray);
                break;
            }
            case 3: {
                statusAndExplain.statType = StatusType.CRITICAL;
                statusAndExplain.explain = new I18NMsgFormat(bundleName, "INACTIVE", objectArray);
                break;
            }
            default: {
                statusAndExplain.statType = StatusType.UNKNOWN;
                statusAndExplain.explain = new I18NMsgFormat(bundleName, "UNEXPECTED", objectArray);
            }
        }
        if (this.loggingOn) {
            System.out.println("ret.statType = " + statusAndExplain.statType);
            System.out.println("ret.explain = " + statusAndExplain.explain.getTranslation(Locale.getDefault()));
        }
        return statusAndExplain;
    }

    private class StatusAndExplain {
        StatusType statType;
        I18NMsgFormat explain;

        StatusAndExplain() {
            ActionFrameRelay.this = ActionFrameRelay.this;
        }
    }
}

